<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T18:03:26.060324704 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="Neoverse-V2" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions per Cycle (Neoverse-V2)">
        <series color="255,153,0" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleNeoverseV2CPU_CYCLES &gt; 0), ($InstructionsPerCycleNeoverseV2INST_RETIRED / $InstructionsPerCycleNeoverseV2CPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Cycle Accounting (Neoverse-V2)">
        <series color="255,153,0" description="This metric is the percentage of cycles that were stalled due to resource constraints in the frontend unit of the processor" expression="if(($FrontendStalledCyclesNeoverseV2CPU_CYCLES &gt; 0), min(($FrontendStalledCyclesNeoverseV2STALL_FRONTEND / $FrontendStalledCyclesNeoverseV2CPU_CYCLES), 1), 0)" name="Frontend Stalled Cycles" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit of the processor" expression="if(($BackendStalledCyclesNeoverseV2CPU_CYCLES &gt; 0), min(($BackendStalledCyclesNeoverseV2STALL_BACKEND / $BackendStalledCyclesNeoverseV2CPU_CYCLES), 1), 0)" name="Backend Stalled Cycles" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Level 1 (Neoverse-V2)">
        <series color="255,153,0" description="This metric is the percentage of total slots that were stalled due to resource constraints in the frontend of the processor" expression="if(($FrontendBoundNeoverseV2CPU_CYCLES &gt; 0), min((($FrontendBoundNeoverseV2STALL_SLOT_FRONTEND / ($FrontendBoundNeoverseV2CPU_CYCLES * 8)) - (($FrontendBoundNeoverseV2BR_MIS_PRED * 1) / $FrontendBoundNeoverseV2CPU_CYCLES)), 1), 0)" name="Frontend Bound" units="percent"/>
        <series color="255,0,229" description="This metric is the percentage of total slots that were stalled due to resource constraints in the backend of the processor" expression="if(($BackendBoundNeoverseV2CPU_CYCLES &gt; 0), min((($BackendBoundNeoverseV2STALL_SLOT_BACKEND / ($BackendBoundNeoverseV2CPU_CYCLES * 8)) - (($BackendBoundNeoverseV2BR_MIS_PRED * 3) / $BackendBoundNeoverseV2CPU_CYCLES)), 1), 0)" name="Backend Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total slots that retired operations, which indicates cycles that were utilized efficiently" expression="if(($RetiringNeoverseV2CPU_CYCLES &gt; 0) &amp;&amp; ($RetiringNeoverseV2OP_SPEC &gt; 0), min((($RetiringNeoverseV2OP_RETIRED / $RetiringNeoverseV2OP_SPEC) * (1 - ($RetiringNeoverseV2STALL_SLOT / ($RetiringNeoverseV2CPU_CYCLES * 8)))), 1), 0)" name="Retiring" units="percent"/>
        <series color="0,255,25" description="This metric is the percentage of total slots that executed operations and didn't retire due to a pipeline flush This indicates cycles that were utilized but inefficiently" expression="if(($BadSpeculationNeoverseV2CPU_CYCLES &gt; 0) &amp;&amp; ($BadSpeculationNeoverseV2OP_SPEC &gt; 0), min((((1 - ($BadSpeculationNeoverseV2OP_RETIRED / $BadSpeculationNeoverseV2OP_SPEC)) * (1 - ($BadSpeculationNeoverseV2STALL_SLOT / ($BadSpeculationNeoverseV2CPU_CYCLES * 8)))) + (($BadSpeculationNeoverseV2BR_MIS_PRED * 4) / $BadSpeculationNeoverseV2CPU_CYCLES)), 1), 0)" name="Bad Speculation" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="General (Neoverse-V2)">
        <series color="255,153,0" description="This metric measures the percentage of operations speculatively executed that are subsequently retired" expression="if(($RetiredOperationsPercentageNeoverseV2OP_SPEC &gt; 0), min(($RetiredOperationsPercentageNeoverseV2OP_RETIRED / $RetiredOperationsPercentageNeoverseV2OP_SPEC), 1), 0)" name="Retired Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction Cache Effectiveness (Frontend Bound) (Neoverse-V2)">
        <series color="255,153,0" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKINeoverseV2INST_RETIRED &gt; 0), (($L1ICacheMPKINeoverseV2L1I_CACHE_REFILL / $L1ICacheMPKINeoverseV2INST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Instruction Cache Effectiveness (Frontend Bound) (Neoverse-V2)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageNeoverseV2L1I_CACHE &gt; 0), min(($L1ICacheMissPercentageNeoverseV2L1I_CACHE_REFILL / $L1ICacheMissPercentageNeoverseV2L1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Bound) (Neoverse-V2)">
        <series color="255,153,0" description="This metric measures the number of instruction TLB Walks per thousand instructions executed" expression="if(($ITLBMPKINeoverseV2INST_RETIRED &gt; 0), (($ITLBMPKINeoverseV2ITLB_WALK / $ITLBMPKINeoverseV2INST_RETIRED) * 1000), 0)" name="ITLB MPKI" units="misses"/>
        <series color="0,102,255" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKINeoverseV2INST_RETIRED &gt; 0), (($L1InstructionTLBMPKINeoverseV2L1I_TLB_REFILL / $L1InstructionTLBMPKINeoverseV2INST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Instruction TLB Effectiveness (Frontend Bound) (Neoverse-V2)">
        <series color="255,153,0" description="This metric measures the ratio of instruction TLB Walks to the total number of instruction TLB accesses. This gives an indication of the effectiveness of the instruction TLB accesses." expression="if(($ITLBWalkPercentageNeoverseV2L1I_TLB &gt; 0), min(($ITLBWalkPercentageNeoverseV2ITLB_WALK / $ITLBWalkPercentageNeoverseV2L1I_TLB), 1), 0)" name="ITLB Walk Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of level 1 instruction TLB accesses missed to the total number of level 1 instruction TLB accesses. This gives an indication of the effectiveness of the level 1 instruction TLB." expression="if(($L1InstructionTLBMissPercentageNeoverseV2L1I_TLB &gt; 0), min(($L1InstructionTLBMissPercentageNeoverseV2L1I_TLB_REFILL / $L1InstructionTLBMissPercentageNeoverseV2L1I_TLB), 1), 0)" name="L1 Instruction TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Bound) (Neoverse-V2)">
        <series color="255,153,0" description="This metric is the percentage of backend stalled cycles that were stalled due a miss in the last level of cache" expression="if(($BackendMemoryBoundNeoverseV2STALL_BACKEND &gt; 0), min(($BackendMemoryBoundNeoverseV2STALL_BACKEND_MEM / $BackendMemoryBoundNeoverseV2STALL_BACKEND), 1), 0)" name="Backend Memory Bound" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data Cache Effectiveness (Backend Memory Bound) (Neoverse-V2)">
        <series color="255,153,0" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKINeoverseV2INST_RETIRED &gt; 0), (($L1DCacheMPKINeoverseV2L1D_CACHE_REFILL / $L1DCacheMPKINeoverseV2INST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
        <series color="0,102,255" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheDemandMPKINeoverseV2INST_RETIRED &gt; 0), ((($L1DCacheDemandMPKINeoverseV2L1D_CACHE_REFILL_RD + $L1DCacheDemandMPKINeoverseV2L1D_CACHE_REFILL_WR) / $L1DCacheDemandMPKINeoverseV2INST_RETIRED) * 1000), 0)" name="L1D Cache Demand MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Data Cache Effectiveness (Backend Memory Bound) (Neoverse-V2)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageNeoverseV2L1D_CACHE &gt; 0), min(($L1DCacheMissPercentageNeoverseV2L1D_CACHE_REFILL / $L1DCacheMissPercentageNeoverseV2L1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Unified Cache Effectiveness (Backend Memory Bound) (Neoverse-V2)">
        <series color="255,153,0" description="This metric measures the number of level 2 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMPKINeoverseV2INST_RETIRED &gt; 0), (($L2CacheMPKINeoverseV2L2D_CACHE_REFILL / $L2CacheMPKINeoverseV2INST_RETIRED) * 1000), 0)" name="L2 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Unified Cache Effectiveness (Backend Memory Bound) (Neoverse-V2)">
        <series color="255,153,0" description="This metric measures the ratio of level 2 cache accesses missed to the total number of level 2 cache accesses. This gives an indication of the effectiveness of the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMissPercentageNeoverseV2L2D_CACHE &gt; 0), min(($L2CacheMissPercentageNeoverseV2L2D_CACHE_REFILL / $L2CacheMissPercentageNeoverseV2L2D_CACHE), 1), 0)" name="L2 Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L3 Unified Cache Effectiveness (Backend Memory Bound) (Neoverse-V2)">
        <series color="255,153,0" description="This metric measures the number of level 3 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMPKINeoverseV2INST_RETIRED &gt; 0), (($L3CacheMPKINeoverseV2L3D_CACHE_REFILL / $L3CacheMPKINeoverseV2INST_RETIRED) * 1000), 0)" name="L3 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L3 Unified Cache Effectiveness (Backend Memory Bound) (Neoverse-V2)">
        <series color="255,153,0" description="This metric measures the ratio of level 3 cache accesses missed to the total number of level 3 cache accesses. This gives an indication of the effectiveness of the level 3 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMissPercentageNeoverseV2L3D_CACHE &gt; 0), min(($L3CacheMissPercentageNeoverseV2L3D_CACHE_REFILL / $L3CacheMissPercentageNeoverseV2L3D_CACHE), 1), 0)" name="L3 Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Last Level Cache Effectiveness (Backend Memory Bound) (Neoverse-V2)">
        <series color="255,153,0" description="This metric measures the number of last level cache read accesses missed per thousand instructions executed" expression="if(($LLCacheReadMPKINeoverseV2INST_RETIRED &gt; 0), (($LLCacheReadMPKINeoverseV2LL_CACHE_MISS_RD / $LLCacheReadMPKINeoverseV2INST_RETIRED) * 1000), 0)" name="LL Cache Read MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Last Level Cache Effectiveness (Backend Memory Bound) (Neoverse-V2)">
        <series color="255,153,0" description="This metric measures the ratio of last level cache read accesses missed to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadMissPercentageNeoverseV2LL_CACHE_RD &gt; 0), min(($LLCacheReadMissPercentageNeoverseV2LL_CACHE_MISS_RD / $LLCacheReadMissPercentageNeoverseV2LL_CACHE_RD), 1), 0)" name="LL Cache Read Miss Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of last level cache read accesses hit in the cache to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadHitPercentageNeoverseV2LL_CACHE_RD &gt; 0), min((($LLCacheReadHitPercentageNeoverseV2LL_CACHE_RD - $LLCacheReadHitPercentageNeoverseV2LL_CACHE_MISS_RD) / $LLCacheReadHitPercentageNeoverseV2LL_CACHE_RD), 1), 0)" name="LL Cache Read Hit Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Memory Bound) (Neoverse-V2)">
        <series color="255,153,0" description="This metric measures the number of data TLB Walks per thousand instructions executed" expression="if(($DTLBMPKINeoverseV2INST_RETIRED &gt; 0), (($DTLBMPKINeoverseV2DTLB_WALK / $DTLBMPKINeoverseV2INST_RETIRED) * 1000), 0)" name="DTLB MPKI" units="misses"/>
        <series color="153,0,255" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKINeoverseV2INST_RETIRED &gt; 0), (($L1DataTLBMPKINeoverseV2L1D_TLB_REFILL / $L1DataTLBMPKINeoverseV2INST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
        <series color="0,255,153" description="This metric measures the number of level 2 unified TLB accesses missed per thousand instructions executed" expression="if(($L2UnifiedTLBMPKINeoverseV2INST_RETIRED &gt; 0), (($L2UnifiedTLBMPKINeoverseV2L2D_TLB_REFILL / $L2UnifiedTLBMPKINeoverseV2INST_RETIRED) * 1000), 0)" name="L2 Unified TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Data TLB Effectiveness (Backend Memory Bound) (Neoverse-V2)">
        <series color="255,153,0" description="This metric measures the ratio of data TLB Walks to the total number of data TLB accesses. This gives an indication of the effectiveness of the data TLB accesses." expression="if(($DTLBWalkPercentageNeoverseV2L1D_TLB &gt; 0), min(($DTLBWalkPercentageNeoverseV2DTLB_WALK / $DTLBWalkPercentageNeoverseV2L1D_TLB), 1), 0)" name="DTLB Walk Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures the ratio of level 1 data TLB accesses missed to the total number of level 1 data TLB accesses. This gives an indication of the effectiveness of the level 1 data TLB." expression="if(($L1DataTLBMissPercentageNeoverseV2L1D_TLB &gt; 0), min(($L1DataTLBMissPercentageNeoverseV2L1D_TLB_REFILL / $L1DataTLBMissPercentageNeoverseV2L1D_TLB), 1), 0)" name="L1 Data TLB Miss Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures the ratio of level 2 unified TLB accesses missed to the total number of level 2 unified TLB accesses. This gives an indication of the effectiveness of the level 2 TLB." expression="if(($L2UnifiedTLBMissPercentageNeoverseV2L2D_TLB &gt; 0), min(($L2UnifiedTLBMissPercentageNeoverseV2L2D_TLB_REFILL / $L2UnifiedTLBMissPercentageNeoverseV2L2D_TLB), 1), 0)" name="L2 Unified TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Neoverse-V2)">
        <series color="255,153,0" description="This metric measures instruction and data barrier operations as a percentage of operations speculatively executed" expression="if(($BarrierOperationsPercentageNeoverseV2INST_SPEC &gt; 0), min(((($BarrierOperationsPercentageNeoverseV2ISB_SPEC + $BarrierOperationsPercentageNeoverseV2DSB_SPEC) + $BarrierOperationsPercentageNeoverseV2DMB_SPEC) / $BarrierOperationsPercentageNeoverseV2INST_SPEC), 1), 0)" name="Barrier Operations Percentage" units="percent"/>
        <series color="255,0,102" description="This metric measures branch operations as a percentage of operations speculatively executed" expression="if(($BranchOperationsPercentageNeoverseV2INST_SPEC &gt; 0), min((($BranchOperationsPercentageNeoverseV2BR_IMMED_SPEC + $BranchOperationsPercentageNeoverseV2BR_INDIRECT_SPEC) / $BranchOperationsPercentageNeoverseV2INST_SPEC), 1), 0)" name="Branch Operations Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageNeoverseV2INST_SPEC &gt; 0), min(($CryptoOperationsPercentageNeoverseV2CRYPTO_SPEC / $CryptoOperationsPercentageNeoverseV2INST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures scalar integer operations as a percentage of operations speculatively executed" expression="if(($IntegerOperationsPercentageNeoverseV2INST_SPEC &gt; 0), min(($IntegerOperationsPercentageNeoverseV2DP_SPEC / $IntegerOperationsPercentageNeoverseV2INST_SPEC), 1), 0)" name="Integer Operations Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageNeoverseV2INST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageNeoverseV2VFP_SPEC / $FloatingPointOperationsPercentageNeoverseV2INST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
        <series color="102,255,0" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageNeoverseV2INST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageNeoverseV2ASE_SPEC / $AdvancedSIMDOperationsPercentageNeoverseV2INST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
        <series color="128,77,0" description="This metric measures scalable vector operations, including loads and stores, as a percentage of operations speculatively executed" expression="if(($SVEOperationsLoadStoreInclusivePercentageNeoverseV2INST_SPEC &gt; 0), min(($SVEOperationsLoadStoreInclusivePercentageNeoverseV2SVE_INST_SPEC / $SVEOperationsLoadStoreInclusivePercentageNeoverseV2INST_SPEC), 1), 0)" name="SVE Operations (Load/Store Inclusive) Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Neoverse-V2)">
        <series color="255,153,0" description="This metric measures half-precision floating point operations as a percentage of operations speculatively executed" expression="if(($HalfPrecisionFloatingPointPercentageNeoverseV2INST_SPEC &gt; 0), min(($HalfPrecisionFloatingPointPercentageNeoverseV2FP_HP_SPEC / $HalfPrecisionFloatingPointPercentageNeoverseV2INST_SPEC), 1), 0)" name="Half Precision Floating Point Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures single-precision floating point operations as a percentage of operations speculatively executed" expression="if(($SinglePrecisionFloatingPointPercentageNeoverseV2INST_SPEC &gt; 0), min(($SinglePrecisionFloatingPointPercentageNeoverseV2FP_SP_SPEC / $SinglePrecisionFloatingPointPercentageNeoverseV2INST_SPEC), 1), 0)" name="Single Precision Floating Point Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures double-precision floating point operations as a percentage of operations speculatively executed" expression="if(($DoublePrecisionFloatingPointPercentageNeoverseV2INST_SPEC &gt; 0), min(($DoublePrecisionFloatingPointPercentageNeoverseV2FP_DP_SPEC / $DoublePrecisionFloatingPointPercentageNeoverseV2INST_SPEC), 1), 0)" name="Double Precision Floating Point Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Neoverse-V2)">
        <series color="255,153,0" description="This metric measures load-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($LoadExclusiveInstructionsPercentageNeoverseV2INST_SPEC &gt; 0), min(($LoadExclusiveInstructionsPercentageNeoverseV2LDREX_SPEC / $LoadExclusiveInstructionsPercentageNeoverseV2INST_SPEC), 1), 0)" name="Load-Exclusive Instructions Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($StoreExclusiveInstructionsPercentageNeoverseV2INST_SPEC &gt; 0), min(($StoreExclusiveInstructionsPercentageNeoverseV2STREX_SPEC / $StoreExclusiveInstructionsPercentageNeoverseV2INST_SPEC), 1), 0)" name="Store-Exclusive Instructions Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Neoverse-V2)">
        <series color="255,153,0" description="This metric measures load operations as a percentage of operations speculatively executed" expression="if(($LoadOperationsPercentageNeoverseV2INST_SPEC &gt; 0), min(($LoadOperationsPercentageNeoverseV2LD_SPEC / $LoadOperationsPercentageNeoverseV2INST_SPEC), 1), 0)" name="Load Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($StoreOperationsPercentageNeoverseV2INST_SPEC &gt; 0), min(($StoreOperationsPercentageNeoverseV2ST_SPEC / $StoreOperationsPercentageNeoverseV2INST_SPEC), 1), 0)" name="Store Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Neoverse-V2)">
        <series color="255,153,0" description="This metric measures memory-read instructions with acquire or acquirepc semantics as a percentage of instructions speculatively executed" expression="if(($LoadAcquireInstructionsPercentageNeoverseV2INST_SPEC &gt; 0), min(($LoadAcquireInstructionsPercentageNeoverseV2RC_LD_SPEC / $LoadAcquireInstructionsPercentageNeoverseV2INST_SPEC), 1), 0)" name="Load-Acquire Instructions Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures memory-write instructions with release semantics as a percentage of instructions speculatively executed" expression="if(($StoreReleaseInstructionsPercentageNeoverseV2INST_SPEC &gt; 0), min(($StoreReleaseInstructionsPercentageNeoverseV2RC_ST_SPEC / $StoreReleaseInstructionsPercentageNeoverseV2INST_SPEC), 1), 0)" name="Store-Release Instructions Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch Effectiveness (Bad Speculation) (Neoverse-V2)">
        <series color="255,153,0" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKINeoverseV2INST_RETIRED &gt; 0), (($BranchMPKINeoverseV2BR_MIS_PRED_RETIRED / $BranchMPKINeoverseV2INST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Effectiveness (Bad Speculation) (Neoverse-V2)">
        <series color="255,153,0" description="This metric measures the ratio of branches mispredicted to the total number of branches architecturally executed. This gives an indication of the effectiveness of the branch prediction unit." expression="if(($BranchMispredictionPercentageNeoverseV2BR_RETIRED &gt; 0), min(($BranchMispredictionPercentageNeoverseV2BR_MIS_PRED_RETIRED / $BranchMispredictionPercentageNeoverseV2BR_RETIRED), 1), 0)" name="Branch Misprediction Percentage" units="percent"/>
   </chart>
    <select-metric id="ARMv9_Neoverse_V2_metric_backend_bound" />
    <select-metric id="ARMv9_Neoverse_V2_metric_backend_mem_bound" />
    <select-metric id="ARMv9_Neoverse_V2_metric_backend_stalled_cycles" />
    <select-metric id="ARMv9_Neoverse_V2_metric_bad_speculation" />
    <select-metric id="ARMv9_Neoverse_V2_metric_barrier_percentage" />
    <select-metric id="ARMv9_Neoverse_V2_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv9_Neoverse_V2_metric_branch_mpki" />
    <select-metric id="ARMv9_Neoverse_V2_metric_branch_percentage" />
    <select-metric id="ARMv9_Neoverse_V2_metric_crypto_percentage" />
    <select-metric id="ARMv9_Neoverse_V2_metric_dtlb_mpki" />
    <select-metric id="ARMv9_Neoverse_V2_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv9_Neoverse_V2_metric_fp16_percentage" />
    <select-metric id="ARMv9_Neoverse_V2_metric_fp32_percentage" />
    <select-metric id="ARMv9_Neoverse_V2_metric_fp64_percentage" />
    <select-metric id="ARMv9_Neoverse_V2_metric_frontend_bound" />
    <select-metric id="ARMv9_Neoverse_V2_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv9_Neoverse_V2_metric_integer_dp_percentage" />
    <select-metric id="ARMv9_Neoverse_V2_metric_ipc" />
    <select-metric id="ARMv9_Neoverse_V2_metric_itlb_mpki" />
    <select-metric id="ARMv9_Neoverse_V2_metric_itlb_walk_ratio" />
    <select-metric id="ARMv9_Neoverse_V2_metric_l1d_cache_demand_mpki" />
    <select-metric id="ARMv9_Neoverse_V2_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_V2_metric_l1d_cache_mpki" />
    <select-metric id="ARMv9_Neoverse_V2_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_V2_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv9_Neoverse_V2_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_V2_metric_l1i_cache_mpki" />
    <select-metric id="ARMv9_Neoverse_V2_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_V2_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv9_Neoverse_V2_metric_l2_cache_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_V2_metric_l2_cache_mpki" />
    <select-metric id="ARMv9_Neoverse_V2_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_V2_metric_l2_tlb_mpki" />
    <select-metric id="ARMv9_Neoverse_V2_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_V2_metric_l3_cache_mpki" />
    <select-metric id="ARMv9_Neoverse_V2_metric_ldrex_percentage" />
    <select-metric id="ARMv9_Neoverse_V2_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv9_Neoverse_V2_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv9_Neoverse_V2_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv9_Neoverse_V2_metric_load_percentage" />
    <select-metric id="ARMv9_Neoverse_V2_metric_rc_ld_percentage" />
    <select-metric id="ARMv9_Neoverse_V2_metric_rc_st_percentage" />
    <select-metric id="ARMv9_Neoverse_V2_metric_retired_ops_percent" />
    <select-metric id="ARMv9_Neoverse_V2_metric_retiring" />
    <select-metric id="ARMv9_Neoverse_V2_metric_scalar_fp_percentage" />
    <select-metric id="ARMv9_Neoverse_V2_metric_simd_percentage" />
    <select-metric id="ARMv9_Neoverse_V2_metric_store_percentage" />
    <select-metric id="ARMv9_Neoverse_V2_metric_strex_percentage" />
    <select-metric id="ARMv9_Neoverse_V2_metric_sve_all_percentage" />
</template>
